﻿<?php
	class Users extends CI_Controller
	{
		//register new user
		public function register()
		{
			$data['title']='Sign Up';
			
			//$data['post']=$this->post_model->get_posts($slug);

			$this->form_validation->set_rules('name','Name','required');
			$this->form_validation->set_rules('username','Username','required|callback_check_username_exists');
			$this->form_validation->set_rules('email','Email','required|callback_check_email_exists');
			$this->form_validation->set_rules('password','Password','required');
			$this->form_validation->set_rules('password2','Confirm Password','matches[password]');

			if($this->form_validation->run()===FALSE)
			{
			$this->load->view('templates/header');
			$this->load->view('users/register',$data);
			$this->load->view('templates/footer');				
			}
			else
			{
				//Encrypting password 
				$enc_password=md5($this->input->post('password'));
				$this->user_model->register($enc_password);
				
				//set flash message
				$this->session->set_flashdata('user_registered','You are now registered and can log in');
				redirect('posts');
			}
			
		}
		

		//login user
		public function login()
		{
			$data['title']='Login';
			
			//$data['post']=$this->post_model->get_posts($slug);

			$this->form_validation->set_rules('username','Username','required');
			$this->form_validation->set_rules('password','Password','required');

			if($this->form_validation->run()===FALSE)
			{
			$this->load->view('templates/header');
			$this->load->view('users/login',$data);
			$this->load->view('templates/footer');				
			}
			else
			{
				//get username from user
				$username=$this->input->post('username');
				//get password from user and encrypt for verification through model
				$password=md5($this->input->post('password'));
				
				//login user , after successful login we will get user_id
				$user_id=$this->user_model->login($username,$password);
				
				//if user_id is valid then create the session
				if($user_id)
				{
					//create session
					$user_data= array(			//passing data of user in array to be available throughout session
						'user_id' =>$user_id,
						'username' =>$username,
						'logged_in' =>true
					);
					
						$this->session->set_userdata($user_data);//setting the user data array to the session
					//set flash message
					$this->session->set_flashdata('user_loggedin','You are now logged in');
					redirect('posts');//redirecting to the posts index page
					
				}
				else
				{
					//set flash message
					$this->session->set_flashdata('login_failed','Login is invalid');
					redirect('users/login');
					
				}
				
			}
			
		}

		//check if username exists	
		public function check_username_exists($username)
		{
			$this->form_validation->set_message('check_username_exists','That Username is taken. Please choose a different one');
			
			if($this->user_model->check_username_exists($username))
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		//check if username exists	
		public function check_email_exists($email)
		{
			$this->form_validation->set_message('check_email_exists','That email is taken. Please choose a different one');
			
			if($this->user_model->check_email_exists($email))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		
		//Log out user from session
		public function logout()
		{
			//Unset user data
			$this->session->unset_userdata('logged_in');
			$this->session->unset_userdata('user_id');
			$this->session->unset_userdata('username');
			
			//set flash message
			$this->session->set_flashdata('user_loggedout','You are now logged out');
			redirect('users/login');
		}
		
		
	}